package com.ejie.ab04b.service;
import com.ejie.ab04b.dao.VmotivosSubsanacionExpDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VmotivosSubsanacionExp;

/**
 * VmotivosSubsanacionExpServiceImpl generated by UDA, 07-jun-2017 16:29:16.
 * @author UDA
 */

@Service(value = "vmotivosSubsanacionExpService")
public class VmotivosSubsanacionExpServiceImpl implements VmotivosSubsanacionExpService {

	@Autowired
	private VmotivosSubsanacionExpDao vmotivosSubsanacionExpDao;

	/**
	 * Inserts a single row in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  VmotivosSubsanacionExp
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 * @return the vmotivos subsanacion exp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VmotivosSubsanacionExp add(VmotivosSubsanacionExp vmotivosSubsanacionExp) {
		return this.vmotivosSubsanacionExpDao.add(vmotivosSubsanacionExp);
	}

	/**
	 * Updates a single row in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  VmotivosSubsanacionExp
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 * @return the vmotivos subsanacion exp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VmotivosSubsanacionExp update(VmotivosSubsanacionExp vmotivosSubsanacionExp) {
		return this.vmotivosSubsanacionExpDao.update(vmotivosSubsanacionExp);
	 }

	/**
	 * Finds a single row in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  VmotivosSubsanacionExp
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 * @return the vmotivos subsanacion exp
	 */
	public VmotivosSubsanacionExp find(VmotivosSubsanacionExp vmotivosSubsanacionExp) {
		return (VmotivosSubsanacionExp) this.vmotivosSubsanacionExpDao.find(vmotivosSubsanacionExp);
	}
	
	/**
	 * Deletes a single row in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VmotivosSubsanacionExp vmotivosSubsanacionExp) {
		this.vmotivosSubsanacionExpDao.remove(vmotivosSubsanacionExp);
	}

	/**
	 * Finds a list of rows in the VmotivosSubsanacionExp table.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<VmotivosSubsanacionExp>
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VmotivosSubsanacionExp> findAll(VmotivosSubsanacionExp vmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto){
		return (List<VmotivosSubsanacionExp>) this.vmotivosSubsanacionExpDao.findAll(vmotivosSubsanacionExp, jqGridRequestDto);
	}
    
	/**
	 * Finds rows in the VmotivosSubsanacionExp table using like.
	 * 
	 *  vmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean	 
	 *  List<VmotivosSubsanacionExp>
	 *
	 * @param vmotivosSubsanacionExp the vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VmotivosSubsanacionExp> findAllLike(VmotivosSubsanacionExp vmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return (List<VmotivosSubsanacionExp>) this.vmotivosSubsanacionExpDao.findAllLike(vmotivosSubsanacionExp, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	 
	/**
	 * Removes rows from the VmotivosSubsanacionExp table.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */	
	public void removeMultiple(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		this.vmotivosSubsanacionExpDao.removeMultiple(filterVmotivosSubsanacionExp, jqGridRequestDto, startsWith);
	}
        
	/**
	 * Filter method in the VmotivosSubsanacionExp table.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  JQGridResponseDto<VmotivosSubsanacionExp>
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */	
	public JQGridResponseDto< VmotivosSubsanacionExp> filter(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		List<VmotivosSubsanacionExp> listaVmotivosSubsanacionExp =  this.vmotivosSubsanacionExpDao.findAllLike(filterVmotivosSubsanacionExp, jqGridRequestDto, false);
		Long recordNum =  this.vmotivosSubsanacionExpDao.findAllLikeCount(filterVmotivosSubsanacionExp != null ? filterVmotivosSubsanacionExp: new VmotivosSubsanacionExp (),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
			List< TableRowDto< VmotivosSubsanacionExp>> reorderSelection = this.vmotivosSubsanacionExpDao.reorderSelection(filterVmotivosSubsanacionExp, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<VmotivosSubsanacionExp>(jqGridRequestDto, recordNum, listaVmotivosSubsanacionExp, reorderSelection);
		}
		return new JQGridResponseDto<VmotivosSubsanacionExp>(jqGridRequestDto, recordNum, listaVmotivosSubsanacionExp);   
	}
    
    /**
     * Searches rows in the VmotivosSubsanacionExp table.
     * 
     *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
     *  searchVmotivosSubsanacionExp VmotivosSubsanacionExp
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  List<TableRowDto<VmotivosSubsanacionExp>>
     *
     * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
     * @param searchVmotivosSubsanacionExp the search vmotivos subsanacion exp
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the list
     */	
    public List< TableRowDto< VmotivosSubsanacionExp>> search(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, VmotivosSubsanacionExp searchVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.vmotivosSubsanacionExpDao.search(filterVmotivosSubsanacionExp, searchVmotivosSubsanacionExp, jqGridRequestDto, startsWith);
	}
    
    /**
     * Reorder the selection made in VmotivosSubsanacionExp table.
     * 
     *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  Object
     *
     * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the object
     */	
    public Object reorderSelection(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.vmotivosSubsanacionExpDao.reorderSelection(filterVmotivosSubsanacionExp, jqGridRequestDto, startsWith);
	}
    
    /*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */
	 
	/**
     * Finder method in the hierarchical the VmotivosSubsanacionExp table.
     * 
     *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>>
     *
     * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the JQ grid response dto
     */	
	public JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>> jerarquia(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		List<JerarquiaDto<VmotivosSubsanacionExp>> listaVmotivosSubsanacionExp =  this.vmotivosSubsanacionExpDao.findAllLikeJerarquia(filterVmotivosSubsanacionExp, jqGridRequestDto);
		Long recordNum = this.vmotivosSubsanacionExpDao.findAllLikeCountJerarquia(filterVmotivosSubsanacionExp, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>>(jqGridRequestDto, recordNum, listaVmotivosSubsanacionExp);
	}
	
	/**
	 * Finder method for siblings rows in the hierarchical the VmotivosSubsanacionExp table.
	 * 
	 *  filterVmotivosSubsanacionExp VmotivosSubsanacionExp
	 *  jqGridRequestDto JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>>
	 *
	 * @param filterVmotivosSubsanacionExp the filter vmotivos subsanacion exp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */	
	public JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>> jerarquiaChildren(VmotivosSubsanacionExp filterVmotivosSubsanacionExp, JQGridRequestDto jqGridRequestDto){
		JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<VmotivosSubsanacionExp>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.vmotivosSubsanacionExpDao.findAllChild(filterVmotivosSubsanacionExp, jqGridRequestDto));
		return jqGridResponseDto;
	}
	
	
}

